<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Comment extends Model 
{

    protected $table = 'comments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function paragraph()
    {
        return $this->hasOne('App\Models\Paragraph');
    }

    public function user()
    {
        return $this->hasOne('App\Models\User');
    }

    public function contract()
    {
        return $this->hasOne('App\Models\Contract');
    }

}